﻿using System;

namespace VA.PPMS.IWS.Common
{
    public class DasMessage
    {
        public const string VaPpmsIdentifier = "VA_PPMS";
        public const string VaNetworkIdentifier = "VA_Network";
        public const string TriWestIdentifier = "CCN_TRW_National";

        public const string OutcomeSource = "OperationOutcome";
        public const string FinalFileIndicator = "F";

        private const string Delimiter = "||";

        public string ConversationId { get; set; }

        public string ResponseConversationId { get; set; }

        public string SenderId { get; set; }

        public string ReceiverId { get; set; }

        public string TransactionId { get; set; }

        public string Content { get; set; }

        public string Source { get; set; }

        public string Index { get; set; }

        public bool IsValid => ReceiverId == VaPpmsIdentifier
                               && !string.IsNullOrEmpty(ConversationId)
                               && !string.IsNullOrEmpty(SenderId)
                               && !string.IsNullOrEmpty(TransactionId);

        public bool IsVaNetwork => !string.IsNullOrEmpty(SenderId) && SenderId.Contains(VaNetworkIdentifier);
        public bool IsVaReceiver => !string.IsNullOrEmpty(ReceiverId) && ReceiverId.Contains(VaNetworkIdentifier);
        public bool IsPpmsSender => !string.IsNullOrEmpty(SenderId) && SenderId == VaPpmsIdentifier;
        public bool IsOutcomeScenario => !string.IsNullOrEmpty(Source) && Source == OutcomeSource;

        public string Id => IsPpmsSender ? ResponseConversationId : ConversationId;

        public DasMessage()
        {
        }

        public DasMessage(string conversationId, string senderId, string receiverId, string transactionId)
        {
            Initialize(conversationId, senderId, receiverId, transactionId);
        }

        public DasMessage(string conversationId, string senderId, string receiverId, string transactionId, string content)
        {
            Initialize(null, senderId, receiverId, transactionId, content);

            if (IsPpmsSender)
                ResponseConversationId = conversationId;
            else
                ConversationId = conversationId;
        }

        public DasMessage(string message)
        {
            ParseMessage(message);
        }

        public override string ToString()
        {
            return $"{ConversationId}{Delimiter}{SenderId}{Delimiter}{ReceiverId}{Delimiter}{TransactionId}{Delimiter}{Content}{Delimiter}{ResponseConversationId}{Delimiter}{Index}";
        }

        private void Initialize(string conversationId, string senderId, string receiverId, string transactionId, string content = null)
        {
            SenderId = senderId;
            ReceiverId = receiverId;
            TransactionId = transactionId;
            Content = content;

            if (IsPpmsSender)
                ResponseConversationId = conversationId;
            else
                ConversationId = conversationId;
        }


        private void ParseMessage(string message)
        {
            Reset();

            var items = message.Split(new[] { Delimiter }, StringSplitOptions.None);

            if (items.Length >= 5)
            {
                ConversationId = items[0];
                SenderId = items[1];
                ReceiverId = items[2];
                TransactionId = items[3];
                Content = items[4];
                if (items.Length > 5) ResponseConversationId = items[5];
                if (items.Length > 6) Index = items[6];
            }
        }

        private void Reset()
        {
            ConversationId = null;
            SenderId = null;
            ReceiverId = null;
            TransactionId = null;
            Content = null;
            ResponseConversationId = null;
            Index = null;
        }
    }
}